/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.task;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.report.CompletionReport;
import com.ibm.hwmca.fw.report.CompletionReportCode;
import com.ibm.hwmca.fw.task.TargetFilterExit;
import com.ibm.hwmca.fw.task.TaskErrorIds;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;

public class TargetFilterPanel
implements TaskErrorIds {
    private static final String TRACE_MASKT = "XFRMTFST";
    private static final String TRACE_MASKF = "XFRMTFSF";
    private static final String TRACE_MASKD = "XFRMTFSD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "FilterTarget");

    public static ObjectId[] display(ObjectId[] objs, PanelTasklet task) {
        Trace.trace(TRACE_MASKD, "->execute()");
        LocalizableText[] names = new LocalizableText[objs.length];
        CompletionReport[] reports = new CompletionReport[objs.length];
        try {
            ObjectId[] result;
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            int i = 0;
            while (i < objs.length) {
                if (objs[i] == null) {
                    Trace.trace(TRACE_MASKD, " Object " + i + " is null");
                    names[i] = new LocalizableText("" + i);
                    reports[i] = new CompletionReport();
                } else {
                    ManagedObject mObj = (ManagedObject)mom.get(objs[i]);
                    if (mObj == null) {
                        Trace.trace(TRACE_MASKD, " Object " + i + " not in MOM");
                        names[i] = new LocalizableText("" + i);
                        reports[i] = new CompletionReport();
                    } else {
                        if (mObj.getUIInfo() == null || mObj.getUIInfo().getUnlocalizedName() == null) {
                            Trace.trace(TRACE_MASKD, " Object " + i + " bad UI Info");
                            names[i] = new LocalizableText("" + i);
                        } else {
                            names[i] = mObj.getUIInfo().getUnlocalizedName();
                        }
                        if (mObj.getLastTaskReport() == null) {
                            reports[i] = new CompletionReport();
                            Trace.trace(TRACE_MASKD, " Object " + i + " no CompletionReport");
                        } else {
                            reports[i] = mObj.getLastTaskReport();
                        }
                    }
                }
                ++i;
            }
            int[] selection = (int[])task.invokeExitOnClient(new TargetFilterExit(names, reports));
            if (selection != null) {
                Trace.trace(TRACE_MASKD, "TargetFiltering got selection from table: #" + selection.length);
            } else {
                Trace.trace(TRACE_MASKD, "TargetFiltering got empty selection ");
            }
            int goodCount = 0;
            if (selection != null) {
                int i2 = 0;
                while (i2 < selection.length) {
                    if (reports[selection[i2]].getCompletionCode().equals(CompletionReportCode.SUCCESS)) {
                        ++goodCount;
                    } else {
                        Trace.trace(TRACE_MASKF, "Completion Code for " + i2 + " is NOT  SUCCESS, object will be removed");
                    }
                    ++i2;
                }
                if (goodCount > 0) {
                    result = new ObjectId[goodCount];
                    int j = 0;
                    int i3 = 0;
                    while (i3 < selection.length) {
                        if (reports[selection[i3]].getCompletionCode().equals(CompletionReportCode.SUCCESS)) {
                            result[j] = objs[selection[i3]];
                            ++j;
                        }
                        ++i3;
                    }
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
            Trace.trace(TRACE_MASKD, "<-exit()");
            return result;
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "(TargetFilterServer) Exception showing message box " + e);
            new FrameworkLog(classLogInfo, 64, e).log();
            return null;
        }
    }
}

